<?php
session_start();
session_destroy();

require 'vendor/autoload.php';
$config = require 'config.php';

use Auth0\SDK\Auth0;
use GuzzleHttp\Client;
use Http\Adapter\Guzzle7\Client as GuzzleAdapter;

$auth0 = new Auth0([
    'domain'        => $config['domain'],
    'clientId'      => $config['client_id'],
    'clientSecret'  => $config['client_secret'],
    'redirectUri'   => $config['redirect_uri'],
    'scope'         => ['openid', 'profile', 'email'],
    'httpClient'    => $httpClient,
    'cookieSecret'  => $cookieSecret,  // Set the cookie secret here
]);

$logoutUrl = $auth0->logout();
header("Location: " . $logoutUrl);
exit;
?>
