<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require 'vendor/autoload.php';
$config = require 'config.php';

use Auth0\SDK\Auth0;
use GuzzleHttp\Client;
use Http\Adapter\Guzzle7\Client as GuzzleAdapter;

$httpClient = new GuzzleAdapter(new Client());


$auth0 = new Auth0([
    'domain'        => $config['domain'],
    'clientId'      => $config['client_id'],
    'clientSecret'  => $config['client_secret'],
    'redirectUri'   => $config['redirect_uri'],
    'cookieSecret'   => $config['cookie_secret'],
    'scope'         => ['openid', 'profile', 'email'],
    'httpClient'    => $httpClient,
]);

// Fetch user info
echo "<pre>"; print_r($_SESSION);
echo "<pre>"; print_r($auth0->getUser()); exit; 


// Try getting the user info
$userInfo = $auth0->getUser();

echo "<pre>"; 
if ($userInfo) {
    print_r($userInfo);
} else {
    echo "No user info returned from Auth0.";
}


$_SESSION['user'] = $userInfo;
header('Location: dashboard.php');
exit;
?>